/*
** Workspc.c
** load and save workspace.
*/

#include "dis6502.h"

#define WORKSPACE_MAGIC10        "DIS6502WRK10"
#define WORKSPACE_MAGIC          "DIS6502WRK14"

typedef struct SEGMENT10
          {
          WORD      wBegin;
          WORD      wEnd;
          BYTE      *lpDump;
          BYTE      *lpType;
          DWORD     dwLineNumber;
          } SEGMENT10;

static char szWorkPath[_MAX_PATH];

static BOOL WorkspaceAskForReset(HWND hWnd)
{
char szAsk[256];

     if (SegmentGetCount() == 0)
          return TRUE;
     if (LoadString(hInst, IDS_ASK_RESET, szAsk, sizeof(szAsk)) == 0)
          strcpy(szAsk, "Loading a workspace will clear all existing segments.\nDo you want to continue ?");
     if (MessageBox(hWnd, szAsk, szTitleApp, MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
          return TRUE;
     return FALSE;
}

/*
** load workspace from disk.
*/
void WorkspaceLoad(HWND hWnd)
{
char szMagic[20];
int fd;
WORD wSegment;
SEGMENT10 Seg;

     if (GetFileName(hWnd, szWorkPath,
                     OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST,
                      IDS_LOAD_WORKSPACE,
                      "Workspace files\0*.WRK\0All files\0*.*\0\0"))
          {
          if ((fd = open(szWorkPath, _O_RDONLY | _O_BINARY)) < 0)
               {
               if (hWnd)
                    Error(hWnd, IDS_ERR_OPENING_FILE, "Error while opening file %s", szWorkPath);
               }
          else {
               memset(szMagic, 0, sizeof(szMagic));
               read(fd, szMagic, strlen(WORKSPACE_MAGIC));
               if (! memcmp(szMagic, WORKSPACE_MAGIC10, strlen(WORKSPACE_MAGIC10)))
                    {
                    if (WorkspaceAskForReset(hWnd))
                         {
                         MainClean(FALSE);
                         MainSetName();
                         read(fd, szBinPath, sizeof(szBinPath));
                         read(fd, szAtrPath, sizeof(szAtrPath));
                         for (wSegment = 0; wSegment < MAX_SEGMENTS; wSegment++)
                              {
                              read(fd, &Segment[wSegment], sizeof(SEGMENT10));
                              Segment[wSegment].bBinary = TRUE;
                              Segment[wSegment].szTitle[0] = 0;
                              }
                         for (wSegment = 0; wSegment < 1024 - MAX_SEGMENTS; wSegment++)
                              read(fd, &Seg, sizeof(SEGMENT10));
                         for (wSegment = 0; wSegment < MAX_SEGMENTS; wSegment++)
                              if (Segment[wSegment].lpDump)
                                   (*CompuLoadSegment)(fd, &Segment[wSegment], TRUE);
                         SegmentUpdate();
                         SetFocus(hSegmentList);
                         DisProcess(hInst, hWnd);
                         }
                    }
               else if (! memcmp(szMagic, WORKSPACE_MAGIC, strlen(WORKSPACE_MAGIC)))
                    {
                    if (WorkspaceAskForReset(hWnd))
                         {
                         MainClean(FALSE);
                         MainSetName();
                         read(fd, szBinPath, sizeof(szBinPath));
                         read(fd, szAtrPath, sizeof(szAtrPath));
                         read(fd, Segment, sizeof(Segment));
                         LabelRestoreUser(hWnd, fd);
                         for (wSegment = 0; wSegment < MAX_SEGMENTS; wSegment++)
                              if (Segment[wSegment].lpDump)
                                   (*CompuLoadSegment)(fd, &Segment[wSegment], TRUE);
                         SegmentUpdate();
                         SetFocus(hSegmentList);
                         DisProcess(hInst, hWnd);
                         }
                    }
               else {
                    if (hWnd)
                         Error(hWnd, IDS_ERR_BAD_WORKSPACE, "File %s is not a valid workspace !", szWorkPath);
                    }
               close(fd);
               }
          }
}

/*
** save workspace to disk.
*/
void WorkspaceSave(HWND hWnd)
{
int fd;
WORD wSegment;
WORD wSize;

     /*
     ** ask the user for a filename.
     */
     if (SaveFileName(hWnd, szWorkPath,
                      OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT,
                      IDS_SAVE_WORKSPACE,
                      "Workspace files\0*.WRK\0All files\0*.*\0\0"))
          {
          if ((fd = open(szWorkPath, _O_CREAT | _O_RDWR | _O_BINARY, _S_IREAD | _S_IWRITE)) < 0)
               Error(hWnd, IDS_ERR_WRITING_FILE, "Error while writing file %s", szWorkPath);
          else {
               write(fd, WORKSPACE_MAGIC, strlen(WORKSPACE_MAGIC));
               write(fd, szBinPath, sizeof(szBinPath));
               write(fd, szAtrPath, sizeof(szAtrPath));
               write(fd, Segment, sizeof(Segment));
               LabelSaveUser(hWnd, fd);
               for (wSegment = 0; wSegment < MAX_SEGMENTS; wSegment++)
                    if (Segment[wSegment].lpDump)
                         {
                         wSize = Segment[wSegment].wEnd - Segment[wSegment].wBegin + 1;
                         write(fd, Segment[wSegment].lpDump, wSize);
                         write(fd, Segment[wSegment].lpType, wSize);
                         }
               close(fd);
               }
          }
}
